VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "ClsSubMenu"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit
'--------------------------------------
'Autor: Leandro Ascierto
'Web: www.leandroascierto.com.ar
'Date: 02/07/2011
'Projet Name: RssReader
'---------------------------------------
Private Type RssItem
    Title As String
    Descriptions As String
    Link As String
    sDate As String
End Type

Private tItems()        As RssItem
Private m_UrlFeed       As String
Private m_hMenu         As Long
Private m_Title         As String
Private m_Link          As String
Private m_TimeActualize As Long
Private m_TimeCount     As Long

Public Function CreateMenu()
    Dim i As Long
    Dim hNewSubMenu As Long
    
    m_hMenu = CreatePopupMenu()
    
    For i = 0 To UBound(tItems)
        hNewSubMenu = CreatePopupMenu()
        AppendMenu m_hMenu, MF_POPUP, hNewSubMenu, tItems(i).Title
    Next
End Function


Public Property Let TimeActualize(ByVal lTime As Long)
    m_TimeActualize = lTime
End Property

Public Property Get TimeActualize() As Long
    TimeActualize = m_TimeActualize
End Property

Public Property Let TimeCount(ByVal lTime As Long)
    m_TimeCount = lTime
End Property

Public Property Get TimeCount() As Long
    TimeCount = m_TimeCount
End Property

Public Property Get Title(ByVal Index As Long) As String
    Title = tItems(Index).Title
End Property

Public Property Get Descriptions(ByVal Index As Long) As String
    Descriptions = tItems(Index).Descriptions
End Property

Public Property Get Link(ByVal Index As Long) As String
    Link = tItems(Index).Link
End Property

Public Property Get sDate(ByVal Index As Long) As String
    sDate = tItems(Index).sDate
End Property

Public Property Get ItemCount() As Long
    If Not IsArrayDim(VarPtrArray(tItems)) Then
        ItemCount = -1
    Else
        ItemCount = UBound(tItems)
    End If
End Property

Public Property Let UrlFeed(ByVal sURL As String)
    m_UrlFeed = sURL
End Property

Public Property Get UrlFeed() As String
    UrlFeed = m_UrlFeed
End Property

Public Property Get hMenu() As Long
    hMenu = m_hMenu
End Property

Public Property Get FeedTitle() As String
    FeedTitle = m_Title
End Property

Public Property Get FeedLink() As String
    FeedLink = m_Link
End Property



Public Function RefreshFeed() As Boolean
    On Error GoTo ErrHandler
    
    Dim sXML            As String
    Dim i               As Long
    Dim Doc             As DOMDocument
    Dim oRssItem        As Object
      
    Set Doc = New DOMDocument
    
    Doc.resolveExternals = True
    Doc.async = False
 
    If Not Doc.Load(m_UrlFeed) Then
        sXML = LoadXML(m_UrlFeed)
        If Not Doc.LoadXML(sXML) Then
            Exit Function
        End If
    End If

    If Doc.parseError Then Exit Function
    
    Set oRssItem = Doc.getElementsByTagName("channel")
    If Not oRssItem Is Nothing Then
        m_Title = oRssItem(0).getElementsByTagName("title")(0).Text
        m_Link = oRssItem(0).getElementsByTagName("link")(0).Text
    End If

    Set oRssItem = Doc.getElementsByTagName("item")
    If Not oRssItem Is Nothing Then
        ReDim tItems(oRssItem.Length - 1)
        For i = 0 To (oRssItem.Length - 1)
            If Not oRssItem(i).getElementsByTagName("title")(0) Is Nothing Then
                tItems(i).Title = oRssItem(i).getElementsByTagName("title")(0).Text
            End If
            If Not oRssItem(i).getElementsByTagName("description")(0) Is Nothing Then
                tItems(i).Descriptions = oRssItem(i).getElementsByTagName("description")(0).Text
            End If
            If Not oRssItem(i).getElementsByTagName("link")(0) Is Nothing Then
                tItems(i).Link = oRssItem(i).getElementsByTagName("link")(0).Text
            End If
            If Not oRssItem(i).getElementsByTagName("pubDate")(0) Is Nothing Then
                tItems(i).sDate = Format(PubDateToVBDate(oRssItem(i).getElementsByTagName("pubDate")(0).Text), "Long Date") '"dddd, dd MMMM yyyy HH:mm:ss"
            End If
        Next
    End If

    RefreshFeed = True
ErrHandler:

End Function
